/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.mixin.recipe.IMixinClientRecipeBook;
import fi.dy.masa.malilib.mixin.recipe.IMixinIngredient;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.crafting.display.StonecutterRecipeDisplay;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class RecipeBookUtils {
    private static final AnsiLogger LOGGER = new AnsiLogger(RecipeBookUtils.class, MaLiLibReference.DEBUG_MODE, true);
    public static ContextMap map;
    private static final int refreshTime = 300;
    private static long lastRefresh;

    public static void toggleDebugLog(boolean toggle) {
        LOGGER.toggleDebug(toggle);
    }

    public static void toggleAnsiColorLog(boolean toggle) {
        LOGGER.toggleAnsiColor(toggle);
    }

    public static String getRecipeCategoryId(RecipeBookCategory category) {
        ResourceKey key = BuiltInRegistries.RECIPE_BOOK_CATEGORY.getResourceKey((Object)category).orElse(null);
        if (key != null) {
            return key.location().toString();
        }
        return "";
    }

    @Nullable
    public static RecipeBookCategory getRecipeCategoryFromId(String id) {
        Holder.Reference catReference = BuiltInRegistries.RECIPE_BOOK_CATEGORY.get(ResourceLocation.tryParse((String)id)).orElse(null);
        if (catReference != null && catReference.isBound()) {
            return (RecipeBookCategory)catReference.value();
        }
        return null;
    }

    @Nullable
    public static ContextMap getMap(Minecraft mc) {
        if (mc.level == null) {
            return null;
        }
        if (map == null || System.currentTimeMillis() - lastRefresh > 300000L) {
            map = SlotDisplayContext.fromLevel((Level)mc.level);
            lastRefresh = System.currentTimeMillis();
        }
        return map;
    }

    public static void clearMap() {
        map = null;
        lastRefresh = -1L;
    }

    public static List<Pair<RecipeDisplayId, RecipeDisplayEntry>> getDisplayEntryFromRecipeBook(ItemStack result, List<Type> types) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return null;
        }
        ClientRecipeBook recipeBook = mc.player.getRecipeBook();
        Map<RecipeDisplayId, RecipeDisplayEntry> recipeMap = ((IMixinClientRecipeBook)recipeBook).malilib_getRecipeMap();
        ArrayList<Pair<RecipeDisplayId, RecipeDisplayEntry>> list = new ArrayList<Pair<RecipeDisplayId, RecipeDisplayEntry>>();
        FeatureFlagSet features = mc.level.enabledFeatures();
        ContextMap map = RecipeBookUtils.getMap(mc);
        if (map == null) {
            return null;
        }
        for (RecipeDisplayId id : recipeMap.keySet()) {
            ItemStack resultSlot;
            RecipeDisplayEntry entry = recipeMap.get(id);
            Type type = Type.fromRecipeDisplay(entry.display());
            if (!entry.craftingRequirements().isPresent() || !types.contains((Object)type) || !entry.display().isEnabled(features) || entry.display().result() instanceof SlotDisplay.SmithingTrimDemoSlotDisplay || (resultSlot = entry.display().result().resolveForFirstStack(map)).isEmpty() || !ItemStack.isSameItem((ItemStack)result, (ItemStack)resultSlot)) continue;
            list.add((Pair<RecipeDisplayId, RecipeDisplayEntry>)Pair.of((Object)id, (Object)entry));
            if (list.size() <= 2) continue;
            return list;
        }
        return list;
    }

    public static boolean matchClientRecipeBookEntry(ItemStack result, List<ItemStack> recipeStacks, RecipeDisplayEntry entry, List<Type> allowed, Minecraft mc) {
        if (mc.level == null || result.isEmpty()) {
            return false;
        }
        ContextMap map = RecipeBookUtils.getMap(mc);
        if (map == null) {
            return false;
        }
        List stacks = entry.resultItems(map);
        LOGGER.debug("matchClientRecipeBookEntry() --> [{}] vs [{}]", recipeStacks, ((ItemStack)stacks.getFirst()).toString());
        if (stacks.isEmpty()) {
            MaLiLib.LOGGER.warn("matchClientRecipeBookEntry(): Failed receiving crafting stacks for NetworkRecipeId: [{}] -- is it even a valid recipe?", (Object)entry.id().index());
            return false;
        }
        if (RecipeBookUtils.areStacksEqual(result, (ItemStack)stacks.getFirst())) {
            if (entry.craftingRequirements().isPresent()) {
                return RecipeBookUtils.compareStacksAndIngredients(recipeStacks, (List)entry.craftingRequirements().get(), Type.fromRecipeDisplay(entry.display()), allowed);
            }
            return true;
        }
        return false;
    }

    public static boolean compareStacksAndIngredients(List<ItemStack> left, List<Ingredient> right, Type type, List<Type> allowed) {
        if (left.isEmpty() || right.isEmpty()) {
            LOGGER.debug("compareStacksAndIngredients() --> EMPTY!!!", new Object[0]);
            return false;
        }
        LOGGER.debug("compareStacksAndIngredients() Type: [{}] --> START", type.toString());
        if (LOGGER.isDebug()) {
            RecipeBookUtils.dumpStacks(left, "LF");
            RecipeBookUtils.dumpIngs(right, "RT");
        }
        if (type == Type.SHAPELESS && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareShapelessRecipe(left, right);
        }
        if (type == Type.SHAPED && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareShapedRecipe(left, right);
        }
        if (type == Type.STONECUTTER && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareStonecutterRecipe(left, right);
        }
        if (type == Type.FURNACE && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareFurnaceRecipe(left, right);
        }
        if (type == Type.SMITHING && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareSmithingRecipe(left, right);
        }
        return false;
    }

    public static boolean compareShapedRecipe(List<ItemStack> left, List<Ingredient> right) {
        LOGGER.debug("compareShapedRecipe() --> size left [{}], right [{}]\n", left.size(), right.size());
        int lPos = 0;
        for (int i = 0; i < right.size(); ++i) {
            ItemStack lStack = left.get(lPos);
            while (lStack.isEmpty() && ++lPos < 9) {
                lStack = left.get(lPos);
                LOGGER.debug(" compareShapedRecipe() [{}] left [{}] (Advance Left), right [{}]", lPos, lStack.toString(), i);
            }
            if (!RecipeBookUtils.checkMatchingItemsEach(lStack, lPos, i, right.get(i))) {
                LOGGER.debug(" FAIL (Shaped)", new Object[0]);
                return false;
            }
            ++lPos;
        }
        LOGGER.debug(" PASS (Shaped)", new Object[0]);
        return true;
    }

    public static boolean compareShapelessRecipe(List<ItemStack> left, List<Ingredient> right) {
        LOGGER.debug("compareShapelessRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            ItemStack lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareShapelessRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.isEmpty()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Shapeless)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Shapeless)", new Object[0]);
        return true;
    }

    @ApiStatus.Experimental
    public static boolean compareStonecutterRecipe(List<ItemStack> left, List<Ingredient> right) {
        LOGGER.debug("compareStonecutterRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            ItemStack lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareStonecutterRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.isEmpty()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Stonecutter)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Stonecutter)", new Object[0]);
        return true;
    }

    @ApiStatus.Experimental
    public static boolean compareFurnaceRecipe(List<ItemStack> left, List<Ingredient> right) {
        LOGGER.debug("compareFurnaceRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            ItemStack lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareFurnaceRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.isEmpty()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Furnace)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Furnace)", new Object[0]);
        return true;
    }

    @ApiStatus.Experimental
    public static boolean compareSmithingRecipe(List<ItemStack> left, List<Ingredient> right) {
        LOGGER.debug("compareSmithingRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            ItemStack lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareSmithingRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.isEmpty()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Smithing)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Smithing)", new Object[0]);
        return true;
    }

    private static boolean checkMatchingItemsEach(ItemStack lStack, int lPos, int i, Ingredient ri) {
        List rItems = ((IMixinIngredient)ri).malilib_getEntries().stream().toList();
        for (Holder rItem : rItems) {
            LOGGER.debug(" checkMatchingItemsEach() [{}] left [{}] / [{}] right [{}] -->", lPos, lStack, i, rItem.getRegisteredName());
            if (ri.test(lStack)) {
                LOGGER.debug(" valid (Test test)", new Object[0]);
                return true;
            }
            if (!RecipeBookUtils.areStacksEqual(lStack, new ItemStack(rItem))) continue;
            LOGGER.debug(" valid (Stack test)", new Object[0]);
            return true;
        }
        LOGGER.debug(" !not valid (Default)", new Object[0]);
        return false;
    }

    public static boolean areStacksEqual(ItemStack left, ItemStack right) {
        return ItemStack.isSameItem((ItemStack)left, (ItemStack)right) && left.getCount() == right.getCount();
    }

    private static void dumpStacks(List<ItemStack> stacks, String side) {
        int i = 0;
        LOGGER.info("DUMP [{}] -->", side);
        for (ItemStack stack : stacks) {
            LOGGER.info(" {}[{}] // [{}]", side, i, stack.toString());
            ++i;
        }
        LOGGER.info("DUMP END [{}]\n", side);
    }

    private static void dumpIngs(List<Ingredient> ings, String side) {
        int i = 0;
        LOGGER.info("DUMP [{}] -->", side);
        for (Ingredient ing : ings) {
            List items = ((IMixinIngredient)ing).malilib_getEntries().stream().toList();
            ArrayList<String> list = new ArrayList<String>();
            for (Holder item : items) {
                list.add(item.getRegisteredName());
            }
            LOGGER.info(" {}[{}] // {}", i, side, ((Object)list).toString());
            ++i;
        }
        LOGGER.info("DUMP END [{}]", side);
    }

    static {
        lastRefresh = -1L;
    }

    public static enum Type implements StringRepresentable
    {
        FURNACE,
        SHAPED,
        SHAPELESS,
        SMITHING,
        STONECUTTER,
        UNKNOWN;

        public static final StringRepresentable.EnumCodec<Type> CODEC;
        public static final StreamCodec<ByteBuf, Type> PACKET_CODEC;
        public static final ImmutableList<Type> VALUES;

        public static Type fromRecipeDisplay(RecipeDisplay type) {
            RecipeDisplay recipeDisplay = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FurnaceRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class, ShapedCraftingRecipeDisplay.class, SmithingRecipeDisplay.class, StonecutterRecipeDisplay.class}, (Object)recipeDisplay, n)) {
                case 0 -> {
                    FurnaceRecipeDisplay ignored = (FurnaceRecipeDisplay)recipeDisplay;
                    yield FURNACE;
                }
                case 1 -> {
                    ShapelessCraftingRecipeDisplay ignored = (ShapelessCraftingRecipeDisplay)recipeDisplay;
                    yield SHAPELESS;
                }
                case 2 -> {
                    ShapedCraftingRecipeDisplay ignored = (ShapedCraftingRecipeDisplay)recipeDisplay;
                    yield SHAPED;
                }
                case 3 -> {
                    SmithingRecipeDisplay ignored = (SmithingRecipeDisplay)recipeDisplay;
                    yield SMITHING;
                }
                case 4 -> {
                    StonecutterRecipeDisplay ignored = (StonecutterRecipeDisplay)recipeDisplay;
                    yield STONECUTTER;
                }
                default -> UNKNOWN;
            };
        }

        @Nullable
        public static Type fromStringStatic(String input) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(input)) continue;
                return type;
            }
            return null;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            PACKET_CODEC = ByteBufCodecs.STRING_UTF8.map(Type::fromStringStatic, Type::getSerializedName);
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

